using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = new long[n];
        long[] y = new long[n];
        
        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split(' ');
            x[i] = long.Parse(parts[0]);
            y[i] = long.Parse(parts[1]);
        }
        
        long totalGreetings = 0;
        
        // Analiziramo sve moguce parove smerova:
        // 
        // Neka su tacke A=(x1,y1) i B=(x2,y2)
        // 
        // 1. Sever(A) - Jug(B): (x1+t, y1) = (x2-t, y2)
        //    => y1=y2, t=(x2-x1)/2, treba t>0 i celo, tj. x2>x1 i (x2-x1)%2=0
        //
        // 2. Istok(A) - Zapad(B): (x1, y1+t) = (x2, y2-t)
        //    => x1=x2, t=(y2-y1)/2, treba t>0 i celo, tj. y2>y1 i (y2-y1)%2=0
        //
        // 3. Sever(A) - Zapad(B): (x1+t, y1) = (x2, y2-t)
        //    => x1+t=x2, y1=y2-t => t=x2-x1=y2-y1
        //    Uslov: x2-x1 = y2-y1 > 0, tj. x2-y2 = x1-y1 i x2>x1
        //
        // 4. Istok(A) - Jug(B): (x1, y1+t) = (x2-t, y2)
        //    => x1=x2-t, y1+t=y2 => t=x2-x1=y2-y1
        //    Uslov: x2-x1 = y2-y1 > 0, tj. x2-y2 = x1-y1 i x2>x1
        //    ISTO kao Sever-Zapad!
        //
        // 5. Sever(A) - Istok(B): (x1+t, y1) = (x2, y2+t)
        //    => x1+t=x2, y1=y2+t => t=x2-x1, t=y1-y2
        //    Uslov: x2-x1 = y1-y2 > 0, tj. x2+y2 = x1+y1 i x2>x1
        //
        // 6. Jug(A) - Zapad(B): (x1-t, y1) = (x2, y2-t)
        //    => x1-t=x2, y1=y2-t => t=x1-x2, t=y2-y1
        //    Uslov: x1-x2 = y2-y1 > 0, tj. x1+y1 = x2+y2 i x1>x2
        //    ISTO kao Sever-Istok (simetricno)!
        //
        // Dakle imamo 4 tipa susreta:
        // A) Sever-Jug (ili Jug-Sever): isti y, |x2-x1| paran
        // B) Istok-Zapad (ili Zapad-Istok): isti x, |y2-y1| paran
        // C) x-y dijagonala: Sever-Zapad + Istok-Jug (2 susreta po paru!)
        // D) x+y dijagonala: Sever-Istok + Jug-Zapad (2 susreta po paru!)
        
        // Dijagonalni susreti na x+y (Sever-Istok i Jug-Zapad - 2 susreta po paru)
        var sumGroups = new Dictionary<long, int>();
        for (int i = 0; i < n; i++)
        {
            long sum = x[i] + y[i];
            if (!sumGroups.ContainsKey(sum))
                sumGroups[sum] = 0;
            sumGroups[sum]++;
        }
        foreach (var count in sumGroups.Values)
        {
            // 2 susreta po paru
            totalGreetings += 2L * count * (count - 1) / 2;
        }
        
        // Dijagonalni susreti na x-y (Sever-Zapad i Istok-Jug - 2 susreta po paru)
        var diffGroups = new Dictionary<long, int>();
        for (int i = 0; i < n; i++)
        {
            long diff = x[i] - y[i];
            if (!diffGroups.ContainsKey(diff))
                diffGroups[diff] = 0;
            diffGroups[diff]++;
        }
        foreach (var count in diffGroups.Values)
        {
            // 2 susreta po paru
            totalGreetings += 2L * count * (count - 1) / 2;
        }
        
        // Sever-Jug susreti: isti y, razlika x mora biti parna
        var nsGroups = new Dictionary<(long y, long xMod), int>();
        for (int i = 0; i < n; i++)
        {
            long xMod = ((x[i] % 2) + 2) % 2;
            var key = (y[i], xMod);
            if (!nsGroups.ContainsKey(key))
                nsGroups[key] = 0;
            nsGroups[key]++;
        }
        foreach (var count in nsGroups.Values)
        {
            totalGreetings += (long)count * (count - 1) / 2;
        }
        
        // Istok-Zapad susreti: isti x, razlika y mora biti parna
        var ewGroups = new Dictionary<(long x, long yMod), int>();
        for (int i = 0; i < n; i++)
        {
            long yMod = ((y[i] % 2) + 2) % 2;
            var key = (x[i], yMod);
            if (!ewGroups.ContainsKey(key))
                ewGroups[key] = 0;
            ewGroups[key]++;
        }
        foreach (var count in ewGroups.Values)
        {
            totalGreetings += (long)count * (count - 1) / 2;
        }
        
        Console.WriteLine(totalGreetings);
    }
}